require( "scripts/style.lua" );




HeaderFont = {
  standardFont,
  16,
  BorderColor
};

BoxFont = {
  standardFont,
  16,
  BorderColor
};

NameFont = {
  standardFont,
  14,
  MenuRedColor
};



function MakeLogin(n)
	return Group {

		Bitmap
		{
			name = "logo",
			x = 30, y = 70,
			scale=0.7,
			image = "playfirstlogo"
		};
		
		Text
		{
			font = HeaderFont,
			name = "enterpfusername",
			x=150,y=80,w=kMax,h=30,
			flags = kHAlignLeft + kVAlignTop,
			label = "enterpfusername"
		};
		
		Text
		{
			font = BoxFont,
			name = "useroremail",
			x=40,y=110,w=120,h=60,
			flags = kHAlignLeft + kVAlignTop,
			label = "useroremail"
		};
		
		Text
		{
			font = BoxFont,
			name = "password",
			x=40,y=160,w=120,h=60,
			flags = kHAlignLeft + kVAlignTop,
			label = "passwordlabel"
		};
		
		Button
		{
			font = BoxFont,
			graphics = CheckboxButtonGraphics,
			name="remember",
			type = kToggle,
			x=60,
			y=190,
			w=250,
			scale=0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			Text
			{
				font = BoxFont,
				name = "rememberlabel",
				x=25,
				y=10,
				w=250,
				h=25,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			},
			command = 
				function()
					ToggleRemember();
				end
		};
		
		Bitmap
		{
			image="backgrounds/textfield.png",
			x=150,
			y=110,
			
			TextEdit
			{
				font = NameFont,
				name = "nameedit",
				x=5,y=6,w=kMax-5,h=kMax,
				length=100,
				
			};
		};
		
		Bitmap
		{
			image="backgrounds/textfield.png",
			x=150,
			y=160,
			
			TextEdit
			{
				font = NameFont,
				name = "passedit",
				x=5,y=6,w=kMax-5,h=kMax,
				password = true,
				length=100,
				
			};
		};
	}
end


AvailableTitleFont = {
  standardFont,
  32,
  BorderColor
};

AvailableInfoFont = {
  standardFont,
  18,
  BorderColor
};

function MakeDownloadAvailable(n)
	return Group {


		Window {
			x=0,y=0,w=kMax,h=kMax,
			name="downloadavailable",
		 
			Text
			{
				font = AvailableTitleFont,
				name = "downloadavailabletitle",
				x=kCenter,y=80,w=kMax,h=30,
				flags = kHAlignCenter + kVAlignTop,
				label = "downloadavailabletitle"
			};
			
			Text
			{
				font = AvailableInfoFont,
				name = "downloadavailable",
				x=40,y=150,w=kMax-40,h=60,
				flags = kHAlignCenter + kVAlignTop,
				label = "downloadavailable"
			};
			
			SetStyle(StandardButtonStyle);
			Button
			{
				x=50,
				y=350,
				name="responseyes",
				label="yes",
				default = true,
				scale=0.7,
				command = 
					function()
						RefreshButton("responseyes");
						InstallDownload();
						CloseResponseWindow();
						
					end
			},
			
			Button
			{
				x=225,
				y=350,
				name="responseno",
				label="no",
				default = true,
				scale=0.7,
				command = 
					function()
						RefreshButton("responseno");
						CloseResponseWindow();
						
					end
			},
			SetStyle(DefaultStyle);
		}
	}
end


ResonseFont = {
  standardFont,
  24,
  BorderColor
};

function MakeResponseWindow(n)
	return Group {


		Window
		{
			x = 0, y = 0,w=kMax,h=kMax,
			name="responsewindow",
			
			Text
			{
				font = ResonseFont,
				name = "responsedetails",
				x=40,y=130,w=kMax-40,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "connectingtoserver"
			};
			
			SetStyle(StandardButtonStyle);
			Button
			{
				x=kCenter,
				y=435,
				name="responseok",
				label="ok",
				default = true,
				scale=0.7,
				command = 
					function()
						RefreshButton("responseok");
						CloseResponseWindow();
					end
			},
			SetStyle(DefaultStyle);
			
		};
	}
end




